#!/bin/sh

username=`whoami`
sourcesDIR=`pwd`
#Please change the following variables to match with the setting of your computer:
PLANTSDIR="/home/$username/Programs/PLANTS"
pyplif="/home/$username/.pyplif/pyplif.py"
#Introduction#
zenity --text-info --width 540 --height 390 \
	--checkbox="Check here to indicate that you have read and agree." \
	--title="iERa 0.9" --html --filename=./.intro.txt
if [ "$?" -ne "0" ]
	then 
		break
	else
		wd="iERa_`date +%y%m%d%H%M%S`"
		mkdir $wd
		cd $wd
		mkdir .tmpdir
		cd .tmpdir
		bkchem input.mol
		if [ ! -e input.mol ]; 
			then 
				cd ..
				zenity --info --title="iERa 0.9" --text="The input.mol file was not found."
				rm -rf .tmpdir
				break
			else 
				cpdID=$(zenity --forms --title="iERa 0.9" --text="Compound Id" --add-entry="Compound name or id: ")
				if [ "$?" -ne "0" ]
					then 
						cd ..
						rm -rf .tmpdir
						break
					else
# 						#Ligand Preparation#							
						(
						babel --title $cpdID -imol input.mol -osmi tmp.smi
						babel --gen3d -ismi tmp.smi -omol2 tmp.mol2
						obabel -ismi tmp.smi -O input.png
						$PLANTSDIR/SPORES1.3 --mode reprot tmp.mol2 input.mol2
						cp input.* ../
						) |
						zenity --progress \
							--title="Ligand Preparation" \
							--text="Waiting ..." \
							--pulsate \
							--auto-close \
							--no-cancel
# 						#Virtual Screening#				
						for j in $(seq 1 5);
							do
								(
								mkdir rep.$j.docking
								cd rep.$j.docking
								cp ../input.mol2 ligand_input.mol2
								cp $sourcesDIR/sources/protein.mol2 .
								cp $sourcesDIR/sources/water.mol2 .
								$PLANTSDIR/PLANTS1.2 --mode screen $sourcesDIR/sources/plants.config
								rm ligand_input.mol2 protein.mol2 water.mol2
								cp $sourcesDIR/sources/OHT.mol2 .
								cp $sourcesDIR/sources/ER_site.mol2 .
								cp $sourcesDIR/sources/config.txt .
								$pyplif
								rm OHT.mol2 ER_site.mol2 config.txt
								grep -Ev LEU pyplif.csv | grep -Ev OHT | sed 's/results\///g' > ../$cpdID.rep_$j.pyplif.csv
								rm pyplif.csv
								cd ..
								cat $cpdID.rep_$j.pyplif.csv >> ../$cpdID.pyplif.csv 
								) |
								zenity --progress \
									--title="Run #$j" \
									--text="Running PLANTS and PyPLIF ..." \
									--pulsate \
									--auto-close \
									--no-cancel										
							done
							(
							cd ..
# 						#Decision Tree for Potent ERalpha Ligand#
							awk '{if ($2 <= -60) print $4}' $cpdID.pyplif.csv | sed 's/0/0,/g' | sed 's/1/1,/g' > tmp1
							awk -F, '{print $239","$242","$320","$407","$430","$470","$68","$75","$96}' tmp1 > tmp2
							awk -F, '{sum1+=$1; sum2+=$2; sum3+=$3; sum4+=$4; sum5+=$5; sum6+=$6; sum7+=$7; sum8+=$8; sum9+=$9} END {print sum1/250","sum2/250","sum3/250","sum4/250","sum5/250","sum6/250","sum7/250","sum8/250","sum9/250}' tmp2 > ensplif.1.csv
							awk -F, '{ if( ( $3 >= 0.158 && $2 >= 0.002 ) ||
								( $3 >= 0.158 && $2 < 0.002 && $4 >= 0.906 ) ||
								( $3 < 0.158 && $2 >= 0.496 && $8 < 0.026 ) ||
								( $3 < 0.158 && $2 >= 0.07 && $9 >= 0.01 && $5 >= 0.002 ) ||
								( $3 < 0.158 && $2 < 0.496 && $9 < 0.01 && $4 >= 0.976 ) ||
								( $3 >= 0.014 && $2 >= 0.07 && $9 < 0.01 && $4 < 0.976 && $1 < 0.022) ||
								( $3 >= 0.014 && $2 >= 0.07 && $9 < 0.01 && $4 < 0.976 && $1 >= 0.022 && $6 >= 0.026 && $7 < 0.014) ) print "1";
								else print "0"}' ensplif.1.csv > pred.potent
# 						#Decision Tree for Marginal ERalpha Ligand#
							awk '{if ($2 <= -58) print $4}' $cpdID.pyplif.csv | sed 's/0/0,/g' | sed 's/1/1,/g' > tmp1
							awk -F, '{print $103","$105","$201","$242","$320","$407","$414","$430","$442","$64","$96}' tmp1 > tmp2
							awk -F, '{sum1+=$1; sum2+=$2; sum3+=$3; sum4+=$4; sum5+=$5; sum6+=$6; sum7+=$7; sum8+=$8; sum9+=$9; sum10+=$10; sum11+=$11} END {print sum1/250","sum2/250","sum3/250","sum4/250","sum5/250","sum6/250","sum7/250","sum8/250","sum9/250","sum10/250","sum11/250}' tmp2 > ensplif.2.csv
							awk -F, '{ if( ( $4 >= 0.09 && $5 >= 0.006 && $8 >= 0.002 ) ||
								( $4 >= 0.09 && $5 >= 0.006 && $8 < 0.002 && $7 >= 0.08 ) ||
								( $4 >= 0.09 && $5 < 0.006 && $1 >= 0.158 && $3 >= 0.052 ) ||
								( $4 < 0.09 && $6 >= 0.946 && $2 >= 0.05 ) ||
								( $4 < 0.09 && $6 < 0.946 &&  $11 >= 0.002 && $4 >= 0.01 && $10 < 0.782 && $9 >= 0.06 ) ) print "1";
								else print "0"}' ensplif.2.csv > pred.marginal
							echo "`cat pred.potent`,`cat pred.marginal`" > tmp3
							awk -F, '{ if ( $1 == 1) print "potent";
								else if ($2 == 1) print "marginal";
								else print "non"}' tmp3 > final.pred
							rm tmp1 tmp2 tmp3 pred.potent pred.marginal
# 							#Closing#				
							zip -r .tmpdir.zip .tmpdir
							echo "The tested compound was predicted as an ERalpha <b>`cat final.pred`</b> ligand." > pred.txt
							cat pred.txt ../.closing.txt > report.txt
							) |
							zenity --progress \
								--title="Finishing" \
								--text="Decision Tree ..." \
								--pulsate \
								--auto-close \
								--no-cancel										
							cd ..
							rm -rf .tmpdir
							zenity --text-info \
								--width 896 --height 640 \
								--title="iERa 0.9" --html --filename=report.txt
							rm pred.txt report.txt
		fi
	fi
fi




